/****************************************************************************

    PROGRAM: DOGDEMO

    PURPOSE: This application demonstrates how to load dogsetup.dll to install
	         the dog driver           
    Copyright (C) SafeNet China Ltd. All Rights Reserved.

****************************************************************************/

#include "windows.h"		    /* required for all Windows applications */
#include "string.h"
#include "stdio.h"
#include "dogdemo.h"                /* specific to this program              */
#include "resource.h"
#include "gsmh.h"

#define INSTALL_ONLY_USB_DOG_DRVIER				1
#define INSTALL_ONLY_PARALLEL_DOG_DRVIER		2
#define INSTALL_ALL_DOG_DRVIER					3

#define UNINSTALL_ONLY_USB_DOG_DRVIER			1
#define UNINSTALL_ONLY_PARALLEL_DOG_DRVIER		2
#define UNINSTALL_ALL_DOG_DRVIER				3



HANDLE hInst;
/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

****************************************************************************/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    DLGPROC lpDialogProc;
	HINSTANCE mlib;
	static char IniFileName[128];
	static char Message[100];
	static char inBuffer[10];
	static char brun[]="haverun";

    HANDLE hMutex;
    hMutex=CreateMutex(
						  NULL,  // SD
						  TRUE,                       // initial owner
						  brun                            // object name
						);
    if(GetLastError()==ERROR_ALREADY_EXISTS )
	{
    
    MessageBox(NULL,"another process is running !","please waiting",MB_OK);
	 return 0;
	}


	mlib = LoadLibrary(TEXT("DOGSETUP.dll"));
		
    if(mlib != NULL)
	  (FARPROC)InstDriver = GetProcAddress(mlib, "InstDriver");
	else
	{
	  MessageBox(NULL,"DOGSETUP.DLL not found!","Error",MB_OK);
	  return 0;
	}

    hInst = hInstance;

    lpDialogProc = MakeProcInstance(DemoDlg, hInstance);

	if (strstr((char*)lpCmdLine,"/?")!=NULL)//display the command line help
	{
		MessageBox(NULL,"Command Line Help(Not distinguish capital or lowercase)\n/? Display the command line help!\n/i Not Display the interface of installation!\n/s Not diaplay any information about installation!\n\nFor example:\nDoginst /i/s Not display any information in the process of installation!\n\n","Hint",MB_OK);
		return FALSE;
	}
	else if(strstr((char*)lpCmdLine,"/i")!=NULL||strstr((char*)lpCmdLine,"/I")!=NULL)//Not display the interface of installation
	{
		//if you want only install the USB driver or Paralle driver ,you can use other Micro.
		//for example 
		//INSTALL_ONLY_USB_DOG_DRVIER
		//INSTALL_ONLY_PARALLEL_DOG_DRVIER

		int retcode = InstDriver(INSTALL_ALL_DOG_DRVIER); 
		if(strstr((char*)lpCmdLine,"/s")!=NULL||strstr((char*)lpCmdLine,"/S")!=NULL)//Not display any information in the process of installation
		{
			return 0;
		}
		if(retcode == 0)
		{
			MessageBox(NULL,"The dog's driver has been installed successfully!","Hint",MB_OK);
		}
		else 
		{
			MessageBox(NULL,"The dog's driver's installation failed!","Hint",MB_OK);
		}
		FreeLibrary(mlib);
		return 0;
	}
	else if(strstr((char*)lpCmdLine,"/r")!=NULL||strstr((char*)lpCmdLine,"/r")!=NULL)//Not display the interface of installation
	{
		//if you want only uninstall the USB driver or Paralle driver ,you can use other Micro.
		//for example 
		//UNINSTALL_ONLY_USB_DOG_DRVIER
		//UNINSTALL_ONLY_PARALLEL_DOG_DRVIER

		int retcode = UninstallDriver(UNINSTALL_ALL_DOG_DRVIER);
		if(strstr((char*)lpCmdLine,"/s")!=NULL||strstr((char*)lpCmdLine,"/S")!=NULL)//Not display any information in the process of installation
		{
			return 0;
		}
		if(retcode == 0)
		{
			MessageBox(NULL,"The dog's driver has been uninstalled successfully!","Hint",MB_OK);
		}
		else 
		{
			MessageBox(NULL,"The dog's driver's uninstallation failed!","Hint",MB_OK);
		}
		FreeLibrary(mlib);
		return 0;
	}

	else//Display the interface of installation
	{
		FreeLibrary(mlib);
		DialogBox(hInstance,(LPCSTR)IDD_DIALOG, NULL,lpDialogProc);
	}

	ReleaseMutex(hMutex);
    FreeProcInstance(lpDialogProc);

    return 0;
}

/****************************************************************************

    FUNCTION: OnDialogInit (HWND)

****************************************************************************/

void OnDialogInit(HWND hDlg)
{
	HMENU hSysMenu;
	hSysMenu = GetSystemMenu(hDlg,FALSE);
    AppendMenu (hSysMenu,MF_SEPARATOR,0,0);
    AppendMenu (hSysMenu,MF_STRING,IDM_ABOUT,"About...");
    RemoveMenu (hSysMenu,SC_SIZE,MF_BYCOMMAND);
    RemoveMenu (hSysMenu,SC_MAXIMIZE,MF_BYCOMMAND);
	RemoveMenu (hSysMenu,SC_MINIMIZE,MF_BYCOMMAND);
	CenterWindow(hDlg);

}

/****************************************************************************

    FUNCTION: OnButtonWriteClicked (HWND)

****************************************************************************/
void OnButtonInstDriver(HWND hDlg) 
{
	int RetCode;
	char Message[100];
	WPARAM wParam=0;
	LPARAM lParam=0;
	HINSTANCE mlib;
	HWND hbutton;

	mlib = LoadLibrary(TEXT("DOGSETUP.dll"));
		
    if(mlib != NULL)
		(FARPROC)InstDriver = GetProcAddress(mlib, "InstDriver");
	else
	{
		wsprintf (Message, "Load DOGSETUP.DLL error.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	    return;
	}
	
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_INSTALL); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_UNINSTALL); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_GET_DRIVER_INFO); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_DISPLAY_INTERFACE); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDCANCEL); 
	EnableWindow(hbutton,FALSE);

	
	
	wsprintf (Message, "                    Please wait ......");
	SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);

	//if you want only install the USB driver or Paralle driver ,you can use other Micro.
	//for example 
	//INSTALL_ONLY_USB_DOG_DRVIER
	//INSTALL_ONLY_PARALLEL_DOG_DRVIER

	RetCode = InstDriver(INSTALL_ALL_DOG_DRVIER);

	FreeLibrary(mlib);

	if(RetCode)
	{
		if (RetCode == 3008)
		{
			wsprintf (Message, "Please log on with administrator identify.\r error code = %d",RetCode);
			SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
		}
		else
		{

			wsprintf (Message, "Install driver failed.\r error code = %d",RetCode);
			SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
		}
		hbutton=GetDlgItem(hDlg,IDC_BUTTON_INSTALL);
		EnableWindow(hbutton,TRUE);
	}
	else
	{
		wsprintf (Message, " The driver has been  installed successfully.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
		hbutton=GetDlgItem(hDlg,IDC_BUTTON_INSTALL); 
		EnableWindow(hbutton,FALSE);
	}
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_UNINSTALL); 
	EnableWindow(hbutton,TRUE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_GET_DRIVER_INFO); 
	EnableWindow(hbutton,TRUE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_DISPLAY_INTERFACE); 
	EnableWindow(hbutton,TRUE);
	hbutton=GetDlgItem(hDlg,IDCANCEL); 
	EnableWindow(hbutton,TRUE);

	
}



void OnButtonUninstallDriver(HWND hDlg) 
{
	int RetCode;
	char Message[100];
	WPARAM wParam=0;
	LPARAM lParam=0;
	HINSTANCE mlib;
	HWND hbutton;

	mlib = LoadLibrary(TEXT("DOGSETUP.dll"));
		
    if(mlib != NULL)
		(FARPROC)UninstallDriver = GetProcAddress(mlib, "UninstallDriver");
	else
	{
		wsprintf (Message, "Load DOGSETUP.DLL error.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	    return;
	}
	

	hbutton=GetDlgItem(hDlg,IDC_BUTTON_INSTALL); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_UNINSTALL); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_GET_DRIVER_INFO); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_DISPLAY_INTERFACE); 
	EnableWindow(hbutton,FALSE);
	hbutton=GetDlgItem(hDlg,IDCANCEL); 
	EnableWindow(hbutton,FALSE);

	
	
	wsprintf (Message, "                    Please wait ......");
	SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);

	//if you want only uninstall the USB driver or Paralle driver ,you can use other Micro.
	//for example 
	//UNINSTALL_ONLY_USB_DOG_DRVIER
	//UNINSTALL_ONLY_PARALLEL_DOG_DRVIER
		
	RetCode = UninstallDriver(UNINSTALL_ALL_DOG_DRVIER);


	FreeLibrary(mlib);

	if(RetCode)
	{
		if (RetCode == 3008)
		{
			wsprintf (Message, "Please log on with administrator identify.\r error code = %d",RetCode);
			SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
		}
		else
		{
			wsprintf (Message, "Uninstall driver failed.\r error code = %d",RetCode);
			SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
		}
	}
	else
	{
		wsprintf (Message, " The driver has been  uninstalled successfully.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}


	hbutton=GetDlgItem(hDlg,IDC_BUTTON_INSTALL); 
	EnableWindow(hbutton,TRUE);

	hbutton=GetDlgItem(hDlg,IDC_BUTTON_UNINSTALL); 
	EnableWindow(hbutton,TRUE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_GET_DRIVER_INFO); 
	EnableWindow(hbutton,TRUE);
	hbutton=GetDlgItem(hDlg,IDC_BUTTON_DISPLAY_INTERFACE); 
	EnableWindow(hbutton,TRUE);
	hbutton=GetDlgItem(hDlg,IDCANCEL); 
	EnableWindow(hbutton,TRUE);
	

}


void OnButtonGetDriverInfo(HWND hDlg)
{
	int RetCode;
	char Message[100];
	WPARAM wParam=0;
	LPARAM lParam=0;
	HINSTANCE mlib;

	mlib = LoadLibrary(TEXT("DOGSETUP.dll"));
    if(mlib != NULL)
		(FARPROC)GetDogDriverInfo = GetProcAddress(mlib, "GetDogDriverInfo");
	else
	{
		wsprintf (Message, "Load DOGSETUP.DLL error.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	    return;
	}

	RetCode = GetDogDriverInfo();

	FreeLibrary(mlib);
	if( 0 == RetCode )
	{
		wsprintf (Message, "Not Find Dog Driver!");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (1 == RetCode)
	{
		wsprintf (Message, "Find the same version USBDog and ParallelDog driver.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (2 == RetCode)
	{
		wsprintf (Message, "Find the same version USBDog driver only.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (3 == RetCode)
	{
		wsprintf (Message, "Find the same version ParallelDog driver only.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (4 == RetCode)
	{
		wsprintf (Message, "Find the old same version USBDog and ParallelDog driver.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (5 == RetCode)
	{
		wsprintf (Message, "Find the old version USBDog driver only.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (6 == RetCode)
	{
		wsprintf (Message, "Find the old version Parallel Dog driver only.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (7 == RetCode)
	{
		wsprintf (Message, "Find the newer same version USBDog and ParallelDog driver.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (8 == RetCode)
	{
		wsprintf (Message, "Find the newer version USBDog driver only.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (9 == RetCode)
	{
		wsprintf (Message, "Find the newer version ParallelDog driver only.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}
	else if (3008 == RetCode)
	{
		wsprintf (Message, " Please log on with administrator identify!\r error code = %d",RetCode);
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);

	}
	else
	{
		wsprintf (Message, " Invalid return code.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	}

}

void OnButtonDisplayInterface(HWND hDlg)
{
	char Message[100];
	WPARAM wParam=0;
	LPARAM lParam=0;
	HINSTANCE mlib;
	mlib = LoadLibrary(TEXT("DOGSETUP.dll"));
    if(mlib != NULL)
		(FARPROC)DriverDialog = GetProcAddress(mlib, "DriverDialog");
	else
	{
		wsprintf (Message, "Load DOGSETUP.DLL error.");
		SetWindowText ( GetDlgItem( hDlg, IDC_STATIC_RESULT ), Message);
	    return;
	}
	DriverDialog();
    if(mlib != NULL)
		FreeLibrary(mlib);

}
/****************************************************************************

    FUNCTION: DemoDlg(HWND, unsigned, WORD, LONG)

****************************************************************************/
BOOL FAR PASCAL DemoDlg(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{ 
    switch (message)
    {

    case WM_INITDIALOG:
        OnDialogInit(hDlg);
    	return (TRUE);
    case WM_COMMAND:
		switch(wParam)
        {
		case IDCANCEL:
			EndDialog(hDlg, TRUE);
			return (TRUE);
		
		case IDC_BUTTON_INSTALL:
			OnButtonInstDriver(hDlg);
			break;
		case IDC_BUTTON_UNINSTALL:
			OnButtonUninstallDriver(hDlg);
			break;
		case IDC_BUTTON_GET_DRIVER_INFO:
			OnButtonGetDriverInfo(hDlg);
			break;
		case IDC_BUTTON_DISPLAY_INTERFACE:
			OnButtonDisplayInterface(hDlg);
    		break;
		}
		break;
    }
    return (FALSE);                       
}
void CenterWindow(HWND hWnd)
{
    RECT rect;
    int systemX,systemY;
    int newX,newY;
    GetWindowRect(hWnd,&rect);
    systemX=GetSystemMetrics(SM_CXFULLSCREEN);
    systemY=GetSystemMetrics(SM_CYFULLSCREEN);
    newX = (systemX-(rect.right-rect.left))/2;
    newY = (systemY-(rect.bottom-rect.top))/2;
    SetWindowPos(hWnd,NULL,newX,newY,0,0,SWP_NOSIZE);
}
